<?php

// Namespace
namespace BMI\Plugin\CRON;

// Use
use BMI\Plugin\BMI_Logger AS Logger;

// Exit on direct access
if (!defined('ABSPATH')) exit;

/**
 * BMI_Crons
 */
class BMI_Crons {

  function __construct() {

  }

  public static function calculate_date($base, $curr = false) {

    $type = $base['type'];
    $week = intval($base['week']);
    $day = intval($base['day']);
    $hour = intval($base['hour']);
    $minutes = intval($base['minute']);

    if (isset($curr) && $curr != false) {
      $timestamp = $curr;
    } else $timestamp = time();

    $current = new \DateTime();
    $current->setTimestamp($timestamp);

    $future = new \DateTime();
    $future->setTimestamp($timestamp);
    $future->setTime($hour, $minutes, 0);

    $c_minute = intval($current->format('i'));
    $c_hour = intval($current->format('G'));
    $c_month_day = intval($current->format('j'));
    $c_month = intval($current->format('n'));
    $c_week = intval($current->format('N'));

    if ($type == 'day') {

      if ($current->getTimestamp() >= $future->getTimestamp()) {

        $future->modify('+1 day');

      }

    } else if ($type == 'week') {

        if ($c_week >= $week) {

          if ($c_week == $week) {

            if ($c_hour >= $hour && (($c_hour > $hour) || ($c_hour == $hour && $c_minute >= $minutes))) {
              // if () {
                $offset = (7 - ($c_week - $week));
                $future->modify("+$offset day");
              // }
            }

          } else {

            // if ($c_hour <= $hour) {
              $offset = (7 - ($c_week - $week));
              $future->modify("+$offset day");
            // }

          }


        } else {

          $offset = ($week - $c_week);
          $future->modify("+$offset day");

        }

    } else if ($type == 'month') {

      if ($c_month_day >= $day) {

        if ($c_month_day == $day && $c_hour <= $hour) {
          if ($c_minute >= $minutes) {

            $days = \cal_days_in_month(CAL_GREGORIAN, $c_month, $current->format('Y'));
            $offset = ($days - ($c_month_day - $day));
            $future->modify("+$offset day");

          }
        } else {

          $offset = ($day - $c_month_day);
          $future->modify("+1 month");
          $future->modify("+$offset day");

        }

      } else {

        $offset = ($day - $c_month_day);
        $future->modify("+$offset day");

      }

    }

    return $future->getTimestamp();

  }

}
